#!/bin/sh
##
# UnShove.sh
# Uncompress and unpack file archives
#
# Wilfredo Sanchez | wsanchez@opensource.apple.com
##

# EXTENSIONS : "tgz" "tar" "gz" "Z"
# OSTYPES    :

for file; do
  location=$(dirname "$file")
  case $file in
    *.tgz | *.tar.gz)
      tar -C "${location}" -x -z -f "${file}"
      ;;
    *.tar)
      tar -C "${location}" -x -f "${file}"
      ;;
    *.gz)
      cd "${location}" && gunzip "${file}"
      ;;
    *.Z)
      cd "${location}" && uncompress "${file}"
      ;;
    *)
      echo "Unknown file extension: ${file}"
      ;;
  esac
done
